﻿using Newtonsoft.Json;
using System.ComponentModel.DataAnnotations;
using System.Text.Json.Serialization;

namespace Model;
public class Product
{
    public const string RequiredErrorMessage = "Das Feld {0} ist ein Pflichtfeld.";

    public Product() 
    {
        ProductProperties = new HashSet<ProductProperty>();
        Images = new HashSet<string>();
        Attachments = new HashSet<string>();
    }

    [Required(ErrorMessage = RequiredErrorMessage)]
    [Display(Name = "Bezeichnung")]
    [JsonPropertyName("name")]
    public string? Name { get; set; }

    [Required(ErrorMessage = RequiredErrorMessage)]
    [Display(Name = "Kategorie")]
    [JsonPropertyName("categoryId")]
    [JsonProperty("categoryId")]
    public string? CategoryId { get; set; }

    [Display(Name = "Beschreibung")]
    [JsonPropertyName("description")]
    [JsonProperty("description")]
    public string? Description { get; set; }

    [JsonPropertyName("primaryImage")]
    [JsonProperty("primaryImage")]
    public string? PrimaryImage { get; set; }

    [JsonPropertyName("properties")]
    public ICollection<ProductProperty> ProductProperties { get; set; }

    [JsonPropertyName("files")]
    public ICollection<string> Attachments { get; set; }

    [JsonPropertyName("images")]
    public ICollection<string> Images { get; set; }

    [System.Text.Json.Serialization.JsonIgnore]
    [Newtonsoft.Json.JsonIgnore]
    public string? PrimaryImageUrl 
    { 
        get; 
        set; 
    }
}
